from django.db import models
from django.contrib.auth import get_user_model
from django.forms import ModelForm


# Create your models here.
User = get_user_model()

class Activity(models.Model):
    user = models.ForeignKey(User,on_delete=models.CASCADE)
    date = models.DateField(null=True,blank=True)
    flexibility = models.BooleanField(default=False)
    musclestrengthdone = models.BooleanField(default=False)
    equilibrion  = models.BooleanField(default=False)
    walking  = models.BooleanField(default=False)
    respiration  = models.BooleanField(default=False)
    stressed = models.BooleanField(default=False)
    ObservationsfromBodyScan = models.TextField(null=True,blank=True)
    ObservationsfromBreathingActivity= models.TextField(null=True,blank=True)
    ObservationsfromFractionalBreathing = models.TextField(null=True,blank=True)
    ObservationsfromWalkingMeditation = models.TextField(null=True,blank=True)
    WalkingMonday = models.IntegerField(verbose_name="Step Number MONDAY",null=True,blank=True)
    WalkingTuesday = models.IntegerField(verbose_name="Step Number TUESDAY",null=True,blank=True)
    WalkingWendsday = models.IntegerField(verbose_name="Step Number WEDNESDAY",null=True,blank=True)
    WalkingThursday = models.IntegerField(verbose_name="Step Number THURSDAY",null=True,blank=True)
    WalkingFriday = models.IntegerField(verbose_name="Step Number FRIDAY",null=True,blank=True)
    WalkingSaterday = models.IntegerField(verbose_name="Step Number SATURDAY",null=True,blank=True)
    WalkingSunday = models.IntegerField(verbose_name="Step Number SUNDAY",null=True,blank=True)
    ActivityMonday = models.IntegerField(verbose_name="Activity Daily MONDAY",null=True,blank=True)
    ActivityTuesday = models.IntegerField(verbose_name="Activity Daily TUESDAY",null=True,blank=True)
    ActivityWendsday = models.IntegerField(verbose_name="Activity Daily WEDNESDAY",null=True,blank=True)
    ActivityThursday = models.IntegerField(verbose_name="Activity Daily THURSDAY",null=True,blank=True)
    ActivityFriday = models.IntegerField(verbose_name="Activity Daily FRIDAY",null=True,blank=True)
    ActivitySaterday = models.IntegerField(verbose_name="Activity Daily SATURDAY",null=True,blank=True)
    ActivitySunday = models.IntegerField(verbose_name="Activity Daily SUNDAY",null=True,blank=True)
    Breakfast = models.TextField(null=True,blank=True)
    Lunch = models.TextField(null=True,blank=True)
    Dinner = models.TextField(null=True,blank=True)
    MiddleDaySnack = models.TextField(null=True,blank=True)
    OutofMeal = models.TextField(null=True,blank=True)
    Supplement = models.TextField(null=True,blank=True)

    

class ActivityForm(ModelForm):
    class Meta:
        model = Activity
        fields = ['date','flexibility','musclestrengthdone','equilibrion','walking','respiration','stressed','ObservationsfromBodyScan','ObservationsfromBreathingActivity','ObservationsfromFractionalBreathing', 'ObservationsfromWalkingMeditation',
                  'WalkingMonday','WalkingTuesday','WalkingWendsday','WalkingThursday','WalkingFriday','WalkingSaterday','WalkingSunday','ActivityMonday'
                  ,'ActivityTuesday','ActivityWendsday','ActivityThursday','ActivityFriday','ActivitySaterday','ActivitySunday','Breakfast','Lunch','Dinner','MiddleDaySnack',
                  'OutofMeal','Supplement']



